function [oracle_scan_power_vec , SgnQ_power_vec]...
    = oracle_power_scan( n, N, alpha, B, M_power, kappa, threshold, num_a_samples )
    
    %range of a for given alpha 
    a_max = min(alpha*n/N, 1); %prevents b from going negative 
    a_vec = linspace(alpha, a_max, num_a_samples);
    
%     a_vec = linspace(alpha, alpha, num_a_samples); %use this to debug t1 error 

    %%% membership matrix Pi
    Pi  = [ones(N, 1)', zeros(n- N,1)'; zeros(N, 1)', ones(n- N,1)']';
    
    %%% power initialize
    oracle_scan_power_vec = zeros(length(a_vec),1);
    SgnQ_power_vec = zeros(length(a_vec),1);
    
    %%% compute power using M_power reps 
    for a_vec_idx = 1:length(a_vec)
        a = a_vec(a_vec_idx); 
    
        %%% scan test values (might need to fix this to dep on a_vec_idx) 
%         scan_values = zeros(M_power, 1);
        oracle_scan_values = zeros(M_power,1);
        SgnQ_pvalues = zeros(M_power,1);
    
        %%% construct structure matrix P_alt 
        c = (alpha*n^2 - 2*alpha*n*N + a*N^2)/(n - N)^2; %%%degree matching (density alpha)
        b = max((n*c - (a + c)*N)/(n - 2*N), 0);     %%%degree matching (density alpha)

        %%%% next if statements should not trigger
        if b < 0 || isnan(b) %%%stop if b negative or Nan
            fprintf('Error: b is bad \n')
            break
        end 
    
        if c < 0 || isnan(c) %%%stop if c negative or Nan
            fprintf('Error: c is bad \n')
            break
        end 
    
        P_alt = [a, b; b, c];       %%% structure matrix
        Omega_alt = Pi*P_alt*Pi';
        
        for sample_idx = 1:M_power
            %%%generate A under alternative 
            A = binornd(ones(n,n), Omega_alt );
            A = A - tril(A) ;
            A = A + A';
    
            %%% compute V, eta^*, \tilde A
            V = ones(1,n) * A * ones(n,1);
            eta = 1 / V^0.5 * A * ones(n,1);
            At = A - eta * eta';
    
            %%%%%%%%%%%%%%%
            %%%oracle scan test that knows C1
            oracle_scan_values(sample_idx) = 1/N*sum(sum(At(1:N, 1:N))); 
    
            %%% compute SgnQ
            SgnQ_pvalues(sample_idx) = SgnQ(A);
        end 
        

        oracle_scan_power_vec(a_vec_idx) = sum(oracle_scan_values > threshold)/M_power;
        SgnQ_power_vec(a_vec_idx) = sum(SgnQ_pvalues < kappa)/M_power ;  
    end 
    
end